<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Lookups\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Deserialize;


/**
 * @property string $phoneNumber
 * @property string $originalLineType
 * @property string $overriddenLineType
 * @property string $overrideReason
 * @property \DateTime $overrideTimestamp
 * @property string $overriddenByAccountSid
 */
class LookupOverrideInstance extends InstanceResource
{
    /**
     * Initialize the LookupOverrideInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $field
     * @param string $phoneNumber
     */
    public function __construct(Version $version, array $payload, ?string $field = null, ?string $phoneNumber = null)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'phoneNumber' => Values::array_get($payload, 'phone_number'),
            'originalLineType' => Values::array_get($payload, 'original_line_type'),
            'overriddenLineType' => Values::array_get($payload, 'overridden_line_type'),
            'overrideReason' => Values::array_get($payload, 'override_reason'),
            'overrideTimestamp' => Deserialize::dateTime(Values::array_get($payload, 'override_timestamp')),
            'overriddenByAccountSid' => Values::array_get($payload, 'overridden_by_account_sid'),
        ];

        $this->solution = ['field' => $field ?: $this->properties['field'], 'phoneNumber' => $phoneNumber ?: $this->properties['phoneNumber'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return LookupOverrideContext Context for this LookupOverrideInstance
     */
    protected function proxy(): LookupOverrideContext
    {
        if (!$this->context) {
            $this->context = new LookupOverrideContext(
                $this->version,
                $this->solution['field'],
                $this->solution['phoneNumber']
            );
        }

        return $this->context;
    }

    /**
     * Create the LookupOverrideInstance
     *
     * @return LookupOverrideInstance Created LookupOverrideInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(): LookupOverrideInstance
    {

        return $this->proxy()->create();
    }

    /**
     * Delete the LookupOverrideInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        return $this->proxy()->delete();
    }

    /**
     * Fetch the LookupOverrideInstance
     *
     * @return LookupOverrideInstance Fetched LookupOverrideInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): LookupOverrideInstance
    {

        return $this->proxy()->fetch();
    }

    /**
     * Update the LookupOverrideInstance
     *
     * @return LookupOverrideInstance Updated LookupOverrideInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(): LookupOverrideInstance
    {

        return $this->proxy()->update();
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Lookups.V2.LookupOverrideInstance ' . \implode(' ', $context) . ']';
    }
}

