<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * User OAuth API
 * User OAuth API
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Oauth\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;


class TokenList extends ListResource
    {
    /**
     * Construct the TokenList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/token';
    }

    /**
     * Create the TokenInstance
     *
     * @param array|Options $options Optional Arguments
     * @return TokenInstance Created TokenInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(array $options = []): TokenInstance
    {

        $options = new Values($options);

        $params = Values::of([
            'account_sid' =>
                $options['accountSid'],
        ]);

        $data = Values::of([
            'grant_type' =>
                $options['grantType'],
            'client_id' =>
                $options['clientId'],
            'client_secret' =>
                $options['clientSecret'],
            'code' =>
                $options['code'],
            'redirect_uri' =>
                $options['redirectUri'],
            'audience' =>
                $options['audience'],
            'refresh_token' =>
                $options['refreshToken'],
            'scope' =>
                $options['scope'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        $payload = $this->version->create('POST', $this->uri, $params, $data, $headers);

        return new TokenInstance(
            $this->version,
            $payload
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Oauth.V2.TokenList]';
    }
}
